unit Krok1;

interface

type
  TZamwienie = class
    function Warto: integer;
  end;

  TWeryfikacjaZamwienia = class
    procedure WeryfikujZamwienie(aZamwienie: TZamwienie);
  end;

  TRealizacjaZamwienia = class
  private
    FWeryfikacjaZamwienia: TWeryfikacjaZamwienia;
  public
    constructor Create;
    destructor Destroy; override;
    procedure RealizujZamwienie(aZamwienie: TZamwienie);
  end;

procedure RealizujZamwienia;

implementation

uses
  System.SysUtils;

procedure RealizujZamwienia;
var
  RealizacjaZamwienia: TRealizacjaZamwienia;
begin
  RealizacjaZamwienia := TRealizacjaZamwienia.Create;
  try
    RealizacjaZamwienia.RealizujZamwienie(TZamwienie.Create);
  finally
    RealizacjaZamwienia.Free;
  end;
end;

function TZamwienie.Warto: integer;
begin
  Result := Random(1000) + 1
end;

constructor TRealizacjaZamwienia.Create;
begin
  FWeryfikacjaZamwienia := TWeryfikacjaZamwienia.Create;
end;

destructor TRealizacjaZamwienia.Destroy;
begin
  FWeryfikacjaZamwienia.Free;
  inherited;
end;

procedure TRealizacjaZamwienia.RealizujZamwienie(aZamwienie: TZamwienie);
begin
  FWeryfikacjaZamwienia.WeryfikujZamwienie(aZamwienie);
end;

procedure TWeryfikacjaZamwienia.WeryfikujZamwienie(aZamwienie: TZamwienie);
begin
  WriteLn('Warto zamwienia: ' + IntToStr(aZamwienie.Warto));
end;

end.

